######################################################333
#############Menarche data
library(MASS)
find("menarche")
names(menarche)
summary(menarche)
menarche
with(menarche,plot(Age,Menarche/Total))
#The fits will produce similar results
men.1<-glm(Menarche/Total~Age,
           family=binomial,
           data = menarche,
           weights=Total,trace=T)
men.1p<-glm(Menarche/Total~Age,
            family=binomial(link=probit),
            data = menarche,
            weights=Total,
            trace=T)
#temporary data frame
tmp<-transform(menarche,
               fv1=predict(men.1,menarche,type="resp"),
               fv2=predict(men.1p,menarche,type="resp"))
with(tmp,{plot(Age,Menarche/Total,col="red")
          lines(Age,fv1,col="navy")
          lines(Age,fv2,col="darkgreen")})
dose.p(men.1,p=1:9/10)
dose.p(men.1p,p=1:9/10)
###################################################################################3

options(contrasts = c("contr.treatment", "contr.poly"))
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20,
             0, 2, 6, 10, 12, 16)
# 1 4 9 13 18 20
# 0 2 6 10 12 16

sex <- factor(rep(c("M", "F"), each = 6))
SF <- cbind(numdead, numalive = 20 - numdead)
SF

Budworms <- data.frame(ldose, sex)
Budworms
# Putting a matrix into a data.frame
# You have to specify in this way!
Budworms$SF <- SF
names(Budworms)

class(Budworms$SF)

rm(sex, ldose, SF)

budworm.lg <- glm(SF ~ sex/ldose,
                  family = binomial, 
	data = Budworms,
                  trace = T,
                  maxit=100,
                  eps=1.0e-9)

budworm.pb <- glm(SF ~ sex/ldose,
                  family = binomial(link = probit), 
	data = Budworms,
                  trace = T,
                  maxit=100,
                  eps=1.0e-9)


summary(budworm.pb)
coef(budworm.lg)/coef(budworm.pb)


# Intepretations in mean space and linear predictors space!

tots<- rep(20, 12)

tmp <- glm(numdead/20 ~ sex/ldose, family=binomial,Budworms, 
			trace=T, weights=tots)

summary(budworm.lg, cor = F)

with(Budworms, {
  plot(c(1,32), c(0,1), type = "n", xlab = "dose",
  	log = "x", axes = F,ylab = "Pr(Death)")
  axis(1, at = 2^(0:5))
  axis(2)

  points(2^ldose[1:6], numdead[1:6]/20, pch = 4)
  points(2^ldose[7:12], numdead[7:12]/20, pch = 1)

  ld <- seq(0, 5, length = 100)
  lines(2^ld, predict(budworm.lg, data.frame(ldose = ld,
    sex = factor(rep("M", length(ld)), levels = levels(sex))),
    type = "response"), col = 3, lwd = 2)
  lines(2^ld, predict(budworm.lg, data.frame(ldose = ld,
    sex = factor(rep("F", length(ld)), levels = levels(sex))),
    type = "response"), lty = 2, col = 2, lwd = 2)
})



budworm.lgA <- update(budworm.lg, . ~ sex/I(ldose - 3))


summary(budworm.lgA, cor = F)$coefficients


anova(update(budworm.lgA, . ~ . + sex/I((ldose - 3)^2)),
      test = "Chisq")

budworm.lg0 <- glm(SF ~ sex + ldose - 1,
  family = binomial, Budworms, trace = T)
anova(budworm.lg0, budworm.lgA, test="Chisq")

summary(budworm.lg0, cor = F)$coefficients

dose.p(budworm.lg0, cf=c(1,3), p=1:9/10)
dose.p(budworm.lg0, cf=c(2,3), p=1:9/10)

options(contrasts = c("contr.treatment", "contr.poly"))

#Birth at weight datasets
attach(birthwt)

race <- factor(race, labels = c("white", "black", "other"))
table(ptl)

# Collapse into 0 1
ptd <- factor(ptl > 0)

table(ftv)
ftv <- factor(ftv)

levels(ftv)[-(1:2)] <- "2+"

table(ftv)  # as a check


bwt <- data.frame(low = factor(low), age, lwt, race,
   smoke = (smoke > 0), ptd, ht = (ht > 0), ui = (ui > 0), ftv)

head(bwt)

detach()
rm(race, ptd, ftv)

birthwt.glm <- glm(low ~ ., family = binomial, data = bwt)
dropterm(birthwt.glm, test="Chisq")

birthwt.step2 <- stepAIC(birthwt.glm, ~ .^2 +
  I(scale(age)^2) + I(scale(lwt)^2), trace = F)

birthwt.step2$anova
dropterm(birthwt.step2, test="Chisq")

table(bwt$low, predict(birthwt.step2) > 0)

attach(bwt)
BWT <- expand.grid(age=14:45, lwt = mean(lwt), 
	race = factor("white", levels = levels(race)),
	smoke = c(T,F), 
	ptd = factor(c(T,F)),
	ht = c(T,F), 
	ui = c(T,F), 
	ftv = levels(ftv))
detach()
require(splines)
require(lattice)
nsAge <- function(x) 
	ns(x, knots = quantile(bwt$age, 1:2/3), 
		Boundary.knots = range(bwt$age))

birthwt.glm2 <- glm(low ~ lwt + ptd+ht+smoke*ui+ftv/nsAge(age), binomial, bwt, trace=T)
anova(birthwt.glm2, test="Chisq")

prob <- predict(birthwt.glm2, BWT, type = "resp")

xyplot(prob ~ age | ftv, BWT, type="l", 
	subset = smoke == F & ptd == F & ht == F & ui == F,
	as.table = T, ylim = c(0,1), ylab = "Pr(Low bwt)")

eta <- predict(birthwt.glm2, BWT, type = "link")
eta[eta < -5] <- NA
xyplot(eta ~ age | ftv, BWT, type="l", 
	subset = smoke == F & ptd == F & ht == F & ui == F,
	as.table = T, ylab = "logit(Pr[Low bwt])")

# _xyplot(eta ~ age | ftv*smoke*ptd*ht*ui, BWT, type="l",
# _	as.table = T, ylab = "logit(Pr[Low bwt])", layout=c(3,4))
# _


birthwt.glm2 <- glm(low ~ lwt + ptd+ht+smoke*ui+ftv/ns(age, 3), binomial, bwt, trace=T)
anova(birthwt.glm2, test="Chisq")

prob <- predict(birthwt.glm2, BWT, type = "resp")

xyplot(prob ~ age | ftv, BWT, type="l", 
	subset = smoke == F & ptd == F & ht == F & ui == F,
	as.table = T, ylim = c(0,1), ylab = "Pr(Low bwt)")


